//
//  Fordtott lengyel logikt hasznl egyszer szmolgp
//
{$Apptype Console}

program Szgep1;

uses  SysUtils, Math;

type
  integer = int64;

 // Sajt kivtelosztly ltrehozsa
 EMJelHiba = class(ERangeError);

const
 mjelek = ['+', '-', '*', '/', '^'];
 kjelek = ['q','x','Q','X'];

var
  a, b   :  Integer;  // szm1, szm2
  c      :  Integer;  // az eredmny
  op     :  char;     // az opertor
  vege   :  boolean;

// Adatbevitel
procedure Beolvas;
begin
    write(':');
    read(op);
    // Rossz opertor esetn sajt kivtel kivltsa
    if not (op in (mjelek + kjelek)) then
     begin
       readln;
       raise EMJelHiba.Create('A mveleti jel csak +,-,*,/,^ lehet!');
     end;
    { Program befejezst jelz opertor esetben az EAbort kivtelt
      kivlt Abort fggvny hvsa }
    if op in kjelek then Abort;
    readln(a, b);
end;

// Szmtsokat vgz fggvny
function Szamol: Integer;
begin
 result:=0;
 case op of
    '+': result:=a+b;                  // sszeads
    '-': result:=a-b;                  // kivons
    '*': result:=a*b;                  // szorzs
    '/': result:=a div b;              // osszts
    '^': result:=trunc(power(a,b));    // hatvnyozs
    end;
end;

// A szmtsi eredmnyt kir eljrs
procedure Kiir;
begin
  writeln(a,op,b,'=',c);
end;

// A fprogram
begin
  vege := False;
  repeat
      try
        Beolvas;
        c:=Szamol;
        Kiir;
      except
         // tfle kivtel kezelse
         on E: EMJelHiba do writeln(E.Message);
         on EDivByZero do writeln('Hiba: nullaval osztas!');
         on EIntOverflow do writeln('Hiba: tulcsordulas!');
         on EInvalidOp do writeln('Matematikai hiba!');
         on EAbort do vege := True;
      else
        // Minden ms kivtel esetn
         writeln('Hiba!');
         readln;
      end;
  until vege;
end.

